@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header"><h1><i class="far fa-credit-card"></i> Moyen de paiement</h1></div>

                <div class="row card-body">
                   	@if(session()->has('warning'))
                        <div class="alert alert-warning }}"> 
                        {!! session('warning') !!}
                       </div>
                    @endif
                    @foreach($mode_paiements as $mode_paiement)
                    <div class="col-md-3">
	                	<div class="card mb-3 text-center">
	                       	<div class="card-header">{{$mode_paiement->libelle}}</div>
	                   		<div class="card-body">
		                   		<img height="100" src="{{asset('images/png/'.$mode_paiement->logo_mode_paiement)}}">
		                   		<form method="POST" action="{{route('paiement.'.$mode_paiement->config)}}" onsubmit="return validerForm();">
		                   		{{csrf_field()}}
		                   		<input type="hidden" name="demande_id" value="{{$demande->id}}"/>
		                   		<input type="hidden" name="montant" value="{{$demande->montant_a_payer}}"/>
		                   		<button type="submit" id="{{$mode_paiement->config}}" class="sbm btn btn-primary">Payer {{$demande->montant_a_payer}}&euro;</button>
		                   		</form>
	                   		</div>
	                   	</div>
                    </div>
                    @endforeach
		        </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('morejs')
<script>
function validerForm(){

$('.sbm').prop('disabled',true);
return true;
}
</script>
@endsection
