@extends('layouts.app')
@section('morecss')
<style>
</style>
@endsection
@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header"><h1>Intervention</h1></div>
 				@if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif
                    @if ($errors->any())
        				<ul class="alert alert-warning">
        					@foreach ($errors->all() as $error)
        					<li>{{$error}}</li> @endforeach
        				</ul>
        				@endif 
        				@if(session()->has('message'))
        				<div class="alert alertToolsBar alert-info alert-dismissible fade show }}"> 
                        {!! session('message') !!}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                          </button>
                        </div>
    			@endif
					
                <div class="card-body">
                	<h2>Descriptif détaillé de l'intervention</h2>
                	<h3> {{$intervention->scheduled_at?\Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $intervention->scheduled_at)->isoFormat('LLLL'):''}}</h3>
                	<p>{{$intervention['descriptif']}}</p>	
					
					<h2>Prestataire</h2> 
					@if ($intervention->user)
					<p>{{$intervention->user->fullname}}</p>
					@else
					<p><em>Prestataire supprimé</em></p>
					@endif
					<p>Montant : {{$intervention->montant_prestation_ht}} eur HT</p>
					<h2>Client</h2>
					@if ($intervention->demande->user)
					<p>{{$intervention->demande->user->fullname}}</p>
					<p>Téléphone {{$intervention->demande->user->telephone}}</p>
					<p>{{$intervention->demande->adresse->adresse}}<br/>
					@else
					<p><em>Client supprimé</em></p>
					@endif
					{{$intervention->demande->adresse->commune->nom}}</p>
					<p><a href="{{route('demandes.show',$intervention->demande->id)}}"><i class="fas fa-eye"></i> Voir la demande client</a></p>
        			@if (count($intervention->demande->messages)) 
        				<span>({{count($intervention->demande->messages)}} messages dont {{count($intervention->demande->messages->where('lu','=',null))}} non lus)</span>
        			@endif
				</div>
                <div class="card-footer">
					<a href="javascript:history.back()" class="btn btn-info">Retour</a>
				</div>
            </div>
        </div>
    </div>
</div>
@endsection