@extends('layouts.app')
@section('morecss')
<style>
</style>
@endsection
@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header"><h1>Intervention</h1></div>
 				@if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif
                    @if ($errors->any())
        				<ul class="alert alert-warning">
        					@foreach ($errors->all() as $error)
        					<li>{{$error}}</li> @endforeach
        				</ul>
        				@endif 
        				@if(session()->has('message'))
        				<div class="alert alertToolsBar alert-info alert-dismissible fade show }}"> 
                        {!! session('message') !!}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                          </button>
                        </div>
    			@endif
					
                <div class="card-body">
                	<form method="POST" class="reponse" enctype="multipart/form-data"
						action="{{ route('interventions.update',$intervention->id) }}">
						@csrf {{ method_field('PATCH') }}
						<fieldset>
							<legend>
								<i class="fas fa-tag"></i> Descriptif de l'intervention
							</legend>
							<div class="form-group">
								<label class="" for="descriptif">Libellé</label> 
								<textarea id="descriptif" name="descriptif"
									class="form-control" rows="10">{{$intervention['descriptif']?$intervention['descriptif']: 'intervention sur '.$intervention->demande->libelle}}
									</textarea>
							</div>
							<div class="form-group">
                            	<label for="document">Uploader le descriptif détaillé</label>
                                <input type="file" class="form-control-file" id="document" name="descriptif_detaillé">
                            </div>
						</fieldset>
						<fieldset>
							<legend><i class="fas fa-tools"></i> Affecter un prestataire</legend>
        					<div class="form-group">
        						@if (count($prestataires) > 0)
        						<label class="col-form-label col-form-label-lg"
        							for="user_id">Prestataire</label>
        						<select id="user_id" name="user_id"
        							class="form-control"> 
        							@foreach ($prestataires as $prestataire)
        							<option value="{{$prestataire->id}}"
        								@if($prestataire->id==$intervention['user_id']) selected
        								@endif>
        								{{$prestataire->fullname}}</option>
    								@endforeach
        						</select>
        						@endif
        					</div>
        					<div class="form-group">
								<label class="" for="montant_prestation_ht">Montant HT</label> <input id="montant_prestation_ht" name="montant_prestation_ht"
									class="form-control form-control-lg" type="number" step="0.01"
									value="{{$intervention->montant_prestation_ht}}" />
							</div>
							<div class="form-group">
								<label class="" for="scheduled_at">Programmée le</label> <input id="scheduled_at" name="scheduled_at"
									class="form-control form-control-lg" type="datetime-local"
									value="{{($intervention->scheduled_at)?Carbon\Carbon::createFromFormat('Y-m-d H:i:s',$intervention->scheduled_at)->format('Y-m-d\TH:i'):'' }}" />
							</div>
        				</fieldset>
						<fieldset>
							<legend>
								<i class="fas fa-coins"></i> Coûts additionnels
							</legend>
							<div class="row">
								<div class="form-group col-12 col-lg-6">
    								<label class="" for="montant_amo_ht">Frais administratifs HT</label> 
    								<input id="montant_amo_ht" name="montant_amo_ht"
    									class="form-control form-control-lg" type="text"
    									value="{{$montant_amo_ht}}" />
    							</div>
    							<div class="form-group col-12 col-lg-6">
    								<label class="" for="montant_dep_ht">Déplacement {{$intervention->demande->adresse->commune->nom}} HT</label> 
    								<input readonly disabled id="montant_dep_ht" name="montant_dep_ht"
    									class="form-control form-control-lg" type="number" step="0.01"
    									value="{{$intervention->demande->adresse->commune->tarif}}" />
    							</div>
							</div>
						</fieldset>
						<fieldset>
							<legend>
								<i class="fas fa-coins"></i> Acompte
							</legend>
							<div class="row">
								<div class="form-group input-group col-12 col-lg-6">
                                  <input name="pcent_acompte" id="pcent_acompte" type="text" class="form-control text-right" aria-label="Pourcentage acompte" value="{{$intervention->demande->pcent_acompte}}">
                                  <div class="input-group-append">
                                    <span class="input-group-text">%</span>
                                  </div>
                                </div>
							</div>
						</fieldset>
						
                        
						<div class="col-12">
							<div class="form-group row">
								<div class="col">
									<a data-toggle="confirmation" data-title="Confirmer?"
										href="javascript:history.back()"
										class="btn btn-info pull-right form-group">{{__('Cancel')}}</a>
								</div>
								<div class="col">
									<button type="submit" class="btn btn-primary">{{ __('Update')}}</button>
								</div>
							</div>
						</div>
					</form>

					
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('morejs')
<script>
$("#montant_prestation_ht").on('change', function() {
	$("#montant_amo_ht").val($(this).val()*0.15);
});
$("#montant_prestation_ht").change();

</script>
@endsection