@extends('layouts.app') 
@section('content')
<div class="col-sm-9 col-lg-10">
	<div class="justify-content-center">
		<div>
			 <div class="card">
				<div class="card-header">
					<h1>Nouvelle commune</h1>
				</div>
				@if ($errors->any())
				<ul class="alert alert-warning">
					@foreach ($errors->all() as $error)
					<li>{{$error}}</li> @endforeach
				</ul>
				@endif 
				@if(session()->has('message'))
				<div class="alert alertToolsBar alert-info alert-dismissible fade show }}"> 
                {!! session('message') !!}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                  </button>
                </div>
				@endif
					
				<div class="card-body">
					<form method="POST" class=""
						action="{{ route('communes.store') }}">
						@csrf
						<fieldset>
							<legend>
								<i class="fas fa-tag"></i> Informations commune
							</legend>
							<div class="form-group">
								<label class="" for="code_postal">Code postal</label> 
								<input id="code_postal"
									name="code_postal" class="form-control form-control-lg" type="text"
									placeholder="code_postal" value="{{old('nom')}}" />
							</div>
							<div class="form-group">
								<label class="" for="libelle">Nom</label> 
								<input id="nom"
									name="nom" class="form-control form-control-lg" type="text"
									placeholder="nom" value="{{old('nom')}}" />
							</div>
							<div class="form-group">
								<label class="" for="libelle">Tarif déplacement</label> 
								<input id="tarif"
									name="tarif" class="form-control form-control-lg" type="number" step="0.05"
									placeholder="tarif" value="{{old('nom')}}" />
							</div>
							 <div class="form-group">
								<label class="col-form-label col-form-label"
									for="tva_id">Tva</label>
								<select id="tva_id" name="tva_id"
									class="form-control"> @foreach ($tvas as $tva)
									<option value="{{$tva->id}}"
										@if ($tva->id==old('nom')) selected
										@endif>{{$tva->libelle}}</option> @endforeach
								</select>
							</div>
						</fieldset>
						<div class="col-12">
							<div class="form-group row">
								<div class="col">
									<a data-toggle="confirmation" data-title="Confirmer?"
										href="{{ route('communes.index') }}"
										class="btn btn-info pull-right form-group">{{__('Cancel')}}</a>
								</div>
								<div class="col">
									<button type="submit" class="btn btn-primary">{{ __('Create')}}</button>
								</div>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection 